import { ThemeService, Theme } from '@primeuix/styled';
import { getKeyValue, isFunction, toCapitalCase, isString, toFlatCase, resolve, isObject, isEmpty, isArray } from '@primeuix/utils/object';
import { uuid } from '@primeuix/utils/uuid';
import Base from '@primevue/core/base';
import BaseStyle from '@primevue/core/base/style';
import PrimeVueService from '@primevue/core/service';
import { mergeProps } from 'vue';

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = true, o = false; try { if (i = (t = t.call(r)).next, 0 === l) ; else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = true, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), true).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: true, configurable: true, writable: true }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var BaseDirective = {
  _getMeta: function _getMeta() {
    return [isObject(arguments.length <= 0 ? undefined : arguments[0]) ? undefined : arguments.length <= 0 ? undefined : arguments[0], resolve(isObject(arguments.length <= 0 ? undefined : arguments[0]) ? arguments.length <= 0 ? undefined : arguments[0] : arguments.length <= 1 ? undefined : arguments[1])];
  },
  _getConfig: function _getConfig(binding, vnode) {
    var _ref, _binding$instance, _vnode$ctx;
    return (_ref = (binding === null || binding === void 0 || (_binding$instance = binding.instance) === null || _binding$instance === void 0 ? void 0 : _binding$instance.$primevue) || (vnode === null || vnode === void 0 || (_vnode$ctx = vnode.ctx) === null || _vnode$ctx === void 0 || (_vnode$ctx = _vnode$ctx.appContext) === null || _vnode$ctx === void 0 || (_vnode$ctx = _vnode$ctx.config) === null || _vnode$ctx === void 0 || (_vnode$ctx = _vnode$ctx.globalProperties) === null || _vnode$ctx === void 0 ? void 0 : _vnode$ctx.$primevue)) === null || _ref === void 0 ? void 0 : _ref.config;
  },
  _getOptionValue: getKeyValue,
  _getPTValue: function _getPTValue() {
    var _instance$binding, _instance$$primevueCo;
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var obj = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var key = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
    var params = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    var searchInDefaultPT = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
    var getValue = function getValue() {
      var value = BaseDirective._getOptionValue.apply(BaseDirective, arguments);
      return isString(value) || isArray(value) ? {
        "class": value
      } : value;
    };
    var _ref2 = ((_instance$binding = instance.binding) === null || _instance$binding === void 0 || (_instance$binding = _instance$binding.value) === null || _instance$binding === void 0 ? void 0 : _instance$binding.ptOptions) || ((_instance$$primevueCo = instance.$primevueConfig) === null || _instance$$primevueCo === void 0 ? void 0 : _instance$$primevueCo.ptOptions) || {},
      _ref2$mergeSections = _ref2.mergeSections,
      mergeSections = _ref2$mergeSections === void 0 ? true : _ref2$mergeSections,
      _ref2$mergeProps = _ref2.mergeProps,
      useMergeProps = _ref2$mergeProps === void 0 ? false : _ref2$mergeProps;
    var global = searchInDefaultPT ? BaseDirective._useDefaultPT(instance, instance.defaultPT(), getValue, key, params) : undefined;
    var self = BaseDirective._usePT(instance, BaseDirective._getPT(obj, instance.$name), getValue, key, _objectSpread(_objectSpread({}, params), {}, {
      global: global || {}
    }));
    var datasets = BaseDirective._getPTDatasets(instance, key);
    return mergeSections || !mergeSections && self ? useMergeProps ? BaseDirective._mergeProps(instance, useMergeProps, global, self, datasets) : _objectSpread(_objectSpread(_objectSpread({}, global), self), datasets) : _objectSpread(_objectSpread({}, self), datasets);
  },
  _getPTDatasets: function _getPTDatasets() {
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var datasetPrefix = 'data-pc-';
    return _objectSpread(_objectSpread({}, key === 'root' && _defineProperty({}, "".concat(datasetPrefix, "name"), toFlatCase(instance.$name))), {}, _defineProperty({}, "".concat(datasetPrefix, "section"), toFlatCase(key)));
  },
  _getPT: function _getPT(pt) {
    var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var callback = arguments.length > 2 ? arguments[2] : undefined;
    var getValue = function getValue(value) {
      var _computedValue$_key;
      var computedValue = callback ? callback(value) : value;
      var _key = toFlatCase(key);
      return (_computedValue$_key = computedValue === null || computedValue === void 0 ? void 0 : computedValue[_key]) !== null && _computedValue$_key !== void 0 ? _computedValue$_key : computedValue;
    };
    return pt && Object.hasOwn(pt, '_usept') ? {
      _usept: pt['_usept'],
      originalValue: getValue(pt.originalValue),
      value: getValue(pt.value)
    } : getValue(pt);
  },
  _usePT: function _usePT() {
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var pt = arguments.length > 1 ? arguments[1] : undefined;
    var callback = arguments.length > 2 ? arguments[2] : undefined;
    var key = arguments.length > 3 ? arguments[3] : undefined;
    var params = arguments.length > 4 ? arguments[4] : undefined;
    var fn = function fn(value) {
      return callback(value, key, params);
    };
    if (pt && Object.hasOwn(pt, '_usept')) {
      var _instance$$primevueCo2;
      var _ref4 = pt['_usept'] || ((_instance$$primevueCo2 = instance.$primevueConfig) === null || _instance$$primevueCo2 === void 0 ? void 0 : _instance$$primevueCo2.ptOptions) || {},
        _ref4$mergeSections = _ref4.mergeSections,
        mergeSections = _ref4$mergeSections === void 0 ? true : _ref4$mergeSections,
        _ref4$mergeProps = _ref4.mergeProps,
        useMergeProps = _ref4$mergeProps === void 0 ? false : _ref4$mergeProps;
      var originalValue = fn(pt.originalValue);
      var value = fn(pt.value);
      if (originalValue === undefined && value === undefined) return undefined;else if (isString(value)) return value;else if (isString(originalValue)) return originalValue;
      return mergeSections || !mergeSections && value ? useMergeProps ? BaseDirective._mergeProps(instance, useMergeProps, originalValue, value) : _objectSpread(_objectSpread({}, originalValue), value) : value;
    }
    return fn(pt);
  },
  _useDefaultPT: function _useDefaultPT() {
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var defaultPT = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var callback = arguments.length > 2 ? arguments[2] : undefined;
    var key = arguments.length > 3 ? arguments[3] : undefined;
    var params = arguments.length > 4 ? arguments[4] : undefined;
    return BaseDirective._usePT(instance, defaultPT, callback, key, params);
  },
  _loadStyles: function _loadStyles() {
    var _config$csp;
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var binding = arguments.length > 1 ? arguments[1] : undefined;
    var vnode = arguments.length > 2 ? arguments[2] : undefined;
    var config = BaseDirective._getConfig(binding, vnode);
    var useStyleOptions = {
      nonce: config === null || config === void 0 || (_config$csp = config.csp) === null || _config$csp === void 0 ? void 0 : _config$csp.nonce
    };
    BaseDirective._loadCoreStyles(instance, useStyleOptions);
    BaseDirective._loadThemeStyles(instance, useStyleOptions);
    BaseDirective._loadScopedThemeStyles(instance, useStyleOptions);
    BaseDirective._removeThemeListeners(instance);
    instance.$loadStyles = function () {
      return BaseDirective._loadThemeStyles(instance, useStyleOptions);
    };
    BaseDirective._themeChangeListener(instance.$loadStyles);
  },
  _loadCoreStyles: function _loadCoreStyles() {
    var _instance$$style, _instance$$style2;
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var useStyleOptions = arguments.length > 1 ? arguments[1] : undefined;
    if (!Base.isStyleNameLoaded((_instance$$style = instance.$style) === null || _instance$$style === void 0 ? void 0 : _instance$$style.name) && (_instance$$style2 = instance.$style) !== null && _instance$$style2 !== void 0 && _instance$$style2.name) {
      var _instance$$style3;
      BaseStyle.loadCSS(useStyleOptions);
      (_instance$$style3 = instance.$style) === null || _instance$$style3 === void 0 || _instance$$style3.loadCSS(useStyleOptions);
      Base.setLoadedStyleName(instance.$style.name);
    }
  },
  _loadThemeStyles: function _loadThemeStyles() {
    var _instance$theme, _instance$$style5, _instance$$style6;
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var useStyleOptions = arguments.length > 1 ? arguments[1] : undefined;
    if (instance !== null && instance !== void 0 && instance.isUnstyled() || (instance === null || instance === void 0 || (_instance$theme = instance.theme) === null || _instance$theme === void 0 ? void 0 : _instance$theme.call(instance)) === 'none') return;

    // common
    if (!Theme.isStyleNameLoaded('common')) {
      var _instance$$style4, _instance$$style4$get;
      var _ref5 = ((_instance$$style4 = instance.$style) === null || _instance$$style4 === void 0 || (_instance$$style4$get = _instance$$style4.getCommonTheme) === null || _instance$$style4$get === void 0 ? void 0 : _instance$$style4$get.call(_instance$$style4)) || {},
        primitive = _ref5.primitive,
        semantic = _ref5.semantic,
        global = _ref5.global,
        style = _ref5.style;
      BaseStyle.load(primitive === null || primitive === void 0 ? void 0 : primitive.css, _objectSpread({
        name: 'primitive-variables'
      }, useStyleOptions));
      BaseStyle.load(semantic === null || semantic === void 0 ? void 0 : semantic.css, _objectSpread({
        name: 'semantic-variables'
      }, useStyleOptions));
      BaseStyle.load(global === null || global === void 0 ? void 0 : global.css, _objectSpread({
        name: 'global-variables'
      }, useStyleOptions));
      BaseStyle.loadStyle(_objectSpread({
        name: 'global-style'
      }, useStyleOptions), style);
      Theme.setLoadedStyleName('common');
    }

    // directive
    if (!Theme.isStyleNameLoaded((_instance$$style5 = instance.$style) === null || _instance$$style5 === void 0 ? void 0 : _instance$$style5.name) && (_instance$$style6 = instance.$style) !== null && _instance$$style6 !== void 0 && _instance$$style6.name) {
      var _instance$$style7, _instance$$style7$get, _instance$$style8, _instance$$style9;
      var _ref6 = ((_instance$$style7 = instance.$style) === null || _instance$$style7 === void 0 || (_instance$$style7$get = _instance$$style7.getDirectiveTheme) === null || _instance$$style7$get === void 0 ? void 0 : _instance$$style7$get.call(_instance$$style7)) || {},
        css = _ref6.css,
        _style = _ref6.style;
      (_instance$$style8 = instance.$style) === null || _instance$$style8 === void 0 || _instance$$style8.load(css, _objectSpread({
        name: "".concat(instance.$style.name, "-variables")
      }, useStyleOptions));
      (_instance$$style9 = instance.$style) === null || _instance$$style9 === void 0 || _instance$$style9.loadStyle(_objectSpread({
        name: "".concat(instance.$style.name, "-style")
      }, useStyleOptions), _style);
      Theme.setLoadedStyleName(instance.$style.name);
    }

    // layer order
    if (!Theme.isStyleNameLoaded('layer-order')) {
      var _instance$$style10, _instance$$style10$ge;
      var layerOrder = (_instance$$style10 = instance.$style) === null || _instance$$style10 === void 0 || (_instance$$style10$ge = _instance$$style10.getLayerOrderThemeCSS) === null || _instance$$style10$ge === void 0 ? void 0 : _instance$$style10$ge.call(_instance$$style10);
      BaseStyle.load(layerOrder, _objectSpread({
        name: 'layer-order',
        first: true
      }, useStyleOptions));
      Theme.setLoadedStyleName('layer-order');
    }
  },
  _loadScopedThemeStyles: function _loadScopedThemeStyles() {
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var useStyleOptions = arguments.length > 1 ? arguments[1] : undefined;
    var preset = instance.preset();
    if (preset && instance.$attrSelector) {
      var _instance$$style11, _instance$$style11$ge, _instance$$style12;
      var _ref7 = ((_instance$$style11 = instance.$style) === null || _instance$$style11 === void 0 || (_instance$$style11$ge = _instance$$style11.getPresetTheme) === null || _instance$$style11$ge === void 0 ? void 0 : _instance$$style11$ge.call(_instance$$style11, preset, "[".concat(instance.$attrSelector, "]"))) || {},
        css = _ref7.css;
      var scopedStyle = (_instance$$style12 = instance.$style) === null || _instance$$style12 === void 0 ? void 0 : _instance$$style12.load(css, _objectSpread({
        name: "".concat(instance.$attrSelector, "-").concat(instance.$style.name)
      }, useStyleOptions));
      instance.scopedStyleEl = scopedStyle.el;
    }
  },
  _themeChangeListener: function _themeChangeListener() {
    var callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
    Base.clearLoadedStyleNames();
    ThemeService.on('theme:change', callback);
  },
  _removeThemeListeners: function _removeThemeListeners() {
    var instance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    ThemeService.off('theme:change', instance.$loadStyles);
  },
  _hook: function _hook(directiveName, hookName, el, binding, vnode, prevVnode) {
    var _binding$value, _config$pt;
    var name = "on".concat(toCapitalCase(hookName));
    var config = BaseDirective._getConfig(binding, vnode);
    var instance = el === null || el === void 0 ? void 0 : el.$instance;
    var selfHook = BaseDirective._usePT(instance, BaseDirective._getPT(binding === null || binding === void 0 || (_binding$value = binding.value) === null || _binding$value === void 0 ? void 0 : _binding$value.pt, directiveName), BaseDirective._getOptionValue, "hooks.".concat(name));
    var defaultHook = BaseDirective._useDefaultPT(instance, config === null || config === void 0 || (_config$pt = config.pt) === null || _config$pt === void 0 || (_config$pt = _config$pt.directives) === null || _config$pt === void 0 ? void 0 : _config$pt[directiveName], BaseDirective._getOptionValue, "hooks.".concat(name));
    var options = {
      el: el,
      binding: binding,
      vnode: vnode,
      prevVnode: prevVnode
    };
    selfHook === null || selfHook === void 0 || selfHook(instance, options);
    defaultHook === null || defaultHook === void 0 || defaultHook(instance, options);
  },
  /* eslint-disable-next-line no-unused-vars */_mergeProps: function _mergeProps() {
    var fn = arguments.length > 1 ? arguments[1] : undefined;
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key2 = 2; _key2 < _len; _key2++) {
      args[_key2 - 2] = arguments[_key2];
    }
    return isFunction(fn) ? fn.apply(void 0, args) : mergeProps.apply(void 0, args);
  },
  _extend: function _extend(name) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var handleHook = function handleHook(hook, el, binding, vnode, prevVnode) {
      var _el$$pd, _el$$instance$hook, _el$$instance, _el$$pd2;
      el._$instances = el._$instances || {};
      var config = BaseDirective._getConfig(binding, vnode);
      var $prevInstance = el._$instances[name] || {};
      var $options = isEmpty($prevInstance) ? _objectSpread(_objectSpread({}, options), options === null || options === void 0 ? void 0 : options.methods) : {};
      el._$instances[name] = _objectSpread(_objectSpread({}, $prevInstance), {}, {
        /* new instance variables to pass in directive methods */
        $name: name,
        $host: el,
        $binding: binding,
        $modifiers: binding === null || binding === void 0 ? void 0 : binding.modifiers,
        $value: binding === null || binding === void 0 ? void 0 : binding.value,
        $el: $prevInstance['$el'] || el || undefined,
        $style: _objectSpread({
          classes: undefined,
          inlineStyles: undefined,
          load: function load() {},
          loadCSS: function loadCSS() {},
          loadStyle: function loadStyle() {}
        }, options === null || options === void 0 ? void 0 : options.style),
        $primevueConfig: config,
        $attrSelector: (_el$$pd = el.$pd) === null || _el$$pd === void 0 || (_el$$pd = _el$$pd[name]) === null || _el$$pd === void 0 ? void 0 : _el$$pd.attrSelector,
        /* computed instance variables */
        defaultPT: function defaultPT() {
          return BaseDirective._getPT(config === null || config === void 0 ? void 0 : config.pt, undefined, function (value) {
            var _value$directives;
            return value === null || value === void 0 || (_value$directives = value.directives) === null || _value$directives === void 0 ? void 0 : _value$directives[name];
          });
        },
        isUnstyled: function isUnstyled() {
          var _el$_$instances$name, _el$_$instances$name2;
          return ((_el$_$instances$name = el._$instances[name]) === null || _el$_$instances$name === void 0 || (_el$_$instances$name = _el$_$instances$name.$binding) === null || _el$_$instances$name === void 0 || (_el$_$instances$name = _el$_$instances$name.value) === null || _el$_$instances$name === void 0 ? void 0 : _el$_$instances$name.unstyled) !== undefined ? (_el$_$instances$name2 = el._$instances[name]) === null || _el$_$instances$name2 === void 0 || (_el$_$instances$name2 = _el$_$instances$name2.$binding) === null || _el$_$instances$name2 === void 0 || (_el$_$instances$name2 = _el$_$instances$name2.value) === null || _el$_$instances$name2 === void 0 ? void 0 : _el$_$instances$name2.unstyled : config === null || config === void 0 ? void 0 : config.unstyled;
        },
        theme: function theme() {
          var _el$_$instances$name3;
          return (_el$_$instances$name3 = el._$instances[name]) === null || _el$_$instances$name3 === void 0 || (_el$_$instances$name3 = _el$_$instances$name3.$primevueConfig) === null || _el$_$instances$name3 === void 0 ? void 0 : _el$_$instances$name3.theme;
        },
        preset: function preset() {
          var _el$_$instances$name4;
          return (_el$_$instances$name4 = el._$instances[name]) === null || _el$_$instances$name4 === void 0 || (_el$_$instances$name4 = _el$_$instances$name4.$binding) === null || _el$_$instances$name4 === void 0 || (_el$_$instances$name4 = _el$_$instances$name4.value) === null || _el$_$instances$name4 === void 0 ? void 0 : _el$_$instances$name4.dt;
        },
        /* instance's methods */
        ptm: function ptm() {
          var _el$_$instances$name5;
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          return BaseDirective._getPTValue(el._$instances[name], (_el$_$instances$name5 = el._$instances[name]) === null || _el$_$instances$name5 === void 0 || (_el$_$instances$name5 = _el$_$instances$name5.$binding) === null || _el$_$instances$name5 === void 0 || (_el$_$instances$name5 = _el$_$instances$name5.value) === null || _el$_$instances$name5 === void 0 ? void 0 : _el$_$instances$name5.pt, key, _objectSpread({}, params));
        },
        ptmo: function ptmo() {
          var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
          var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
          return BaseDirective._getPTValue(el._$instances[name], obj, key, params, false);
        },
        cx: function cx() {
          var _el$_$instances$name6, _el$_$instances$name7;
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          return !((_el$_$instances$name6 = el._$instances[name]) !== null && _el$_$instances$name6 !== void 0 && _el$_$instances$name6.isUnstyled()) ? BaseDirective._getOptionValue((_el$_$instances$name7 = el._$instances[name]) === null || _el$_$instances$name7 === void 0 || (_el$_$instances$name7 = _el$_$instances$name7.$style) === null || _el$_$instances$name7 === void 0 ? void 0 : _el$_$instances$name7.classes, key, _objectSpread({}, params)) : undefined;
        },
        sx: function sx() {
          var _el$_$instances$name8;
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var when = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
          var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
          return when ? BaseDirective._getOptionValue((_el$_$instances$name8 = el._$instances[name]) === null || _el$_$instances$name8 === void 0 || (_el$_$instances$name8 = _el$_$instances$name8.$style) === null || _el$_$instances$name8 === void 0 ? void 0 : _el$_$instances$name8.inlineStyles, key, _objectSpread({}, params)) : undefined;
        }
      }, $options);
      el.$instance = el._$instances[name]; // pass instance data to hooks
      (_el$$instance$hook = (_el$$instance = el.$instance)[hook]) === null || _el$$instance$hook === void 0 || _el$$instance$hook.call(_el$$instance, el, binding, vnode, prevVnode); // handle hook in directive implementation
      el["$".concat(name)] = el.$instance; // expose all options with $<directive_name>
      BaseDirective._hook(name, hook, el, binding, vnode, prevVnode); // handle hooks during directive uses (global and self-definition)

      el.$pd || (el.$pd = {});
      el.$pd[name] = _objectSpread(_objectSpread({}, (_el$$pd2 = el.$pd) === null || _el$$pd2 === void 0 ? void 0 : _el$$pd2[name]), {}, {
        name: name,
        instance: el._$instances[name]
      });
    };
    var handleWatchers = function handleWatchers(el) {
      var _watchers$config2, _watchers$configRipp2, _instance$$primevueCo3;
      var instance = el._$instances[name];
      var watchers = instance === null || instance === void 0 ? void 0 : instance.watch;
      var handleWatchConfig = function handleWatchConfig(_ref8) {
        var _watchers$config;
        var newValue = _ref8.newValue,
          oldValue = _ref8.oldValue;
        return watchers === null || watchers === void 0 || (_watchers$config = watchers['config']) === null || _watchers$config === void 0 ? void 0 : _watchers$config.call(instance, newValue, oldValue);
      };
      var handleWatchConfigRipple = function handleWatchConfigRipple(_ref9) {
        var _watchers$configRipp;
        var newValue = _ref9.newValue,
          oldValue = _ref9.oldValue;
        return watchers === null || watchers === void 0 || (_watchers$configRipp = watchers['config.ripple']) === null || _watchers$configRipp === void 0 ? void 0 : _watchers$configRipp.call(instance, newValue, oldValue);
      };
      instance.$watchersCallback = {
        config: handleWatchConfig,
        'config.ripple': handleWatchConfigRipple
      };

      // for 'config'
      watchers === null || watchers === void 0 || (_watchers$config2 = watchers['config']) === null || _watchers$config2 === void 0 || _watchers$config2.call(instance, instance === null || instance === void 0 ? void 0 : instance.$primevueConfig);
      PrimeVueService.on('config:change', handleWatchConfig);

      // for 'config.ripple'
      watchers === null || watchers === void 0 || (_watchers$configRipp2 = watchers['config.ripple']) === null || _watchers$configRipp2 === void 0 || _watchers$configRipp2.call(instance, instance === null || instance === void 0 || (_instance$$primevueCo3 = instance.$primevueConfig) === null || _instance$$primevueCo3 === void 0 ? void 0 : _instance$$primevueCo3.ripple);
      PrimeVueService.on('config:ripple:change', handleWatchConfigRipple);
    };
    var stopWatchers = function stopWatchers(el) {
      var watchers = el._$instances[name].$watchersCallback;
      if (watchers) {
        PrimeVueService.off('config:change', watchers.config);
        PrimeVueService.off('config:ripple:change', watchers['config.ripple']);
      }
    };
    return {
      created: function created(el, binding, vnode, prevVnode) {
        el.$pd || (el.$pd = {});
        el.$pd[name] = {
          name: name,
          attrSelector: uuid('pd')
        };
        handleHook('created', el, binding, vnode, prevVnode);
      },
      beforeMount: function beforeMount(el, binding, vnode, prevVnode) {
        var _el$$pd$name;
        BaseDirective._loadStyles((_el$$pd$name = el.$pd[name]) === null || _el$$pd$name === void 0 ? void 0 : _el$$pd$name.instance, binding, vnode);
        handleHook('beforeMount', el, binding, vnode, prevVnode);
        handleWatchers(el);
      },
      mounted: function mounted(el, binding, vnode, prevVnode) {
        var _el$$pd$name2;
        BaseDirective._loadStyles((_el$$pd$name2 = el.$pd[name]) === null || _el$$pd$name2 === void 0 ? void 0 : _el$$pd$name2.instance, binding, vnode);
        handleHook('mounted', el, binding, vnode, prevVnode);
      },
      beforeUpdate: function beforeUpdate(el, binding, vnode, prevVnode) {
        handleHook('beforeUpdate', el, binding, vnode, prevVnode);
      },
      updated: function updated(el, binding, vnode, prevVnode) {
        var _el$$pd$name3;
        BaseDirective._loadStyles((_el$$pd$name3 = el.$pd[name]) === null || _el$$pd$name3 === void 0 ? void 0 : _el$$pd$name3.instance, binding, vnode);
        handleHook('updated', el, binding, vnode, prevVnode);
      },
      beforeUnmount: function beforeUnmount(el, binding, vnode, prevVnode) {
        var _el$$pd$name4;
        stopWatchers(el);
        BaseDirective._removeThemeListeners((_el$$pd$name4 = el.$pd[name]) === null || _el$$pd$name4 === void 0 ? void 0 : _el$$pd$name4.instance);
        handleHook('beforeUnmount', el, binding, vnode, prevVnode);
      },
      unmounted: function unmounted(el, binding, vnode, prevVnode) {
        var _el$$pd$name5;
        (_el$$pd$name5 = el.$pd[name]) === null || _el$$pd$name5 === void 0 || (_el$$pd$name5 = _el$$pd$name5.instance) === null || _el$$pd$name5 === void 0 || (_el$$pd$name5 = _el$$pd$name5.scopedStyleEl) === null || _el$$pd$name5 === void 0 || (_el$$pd$name5 = _el$$pd$name5.value) === null || _el$$pd$name5 === void 0 || _el$$pd$name5.remove();
        handleHook('unmounted', el, binding, vnode, prevVnode);
      }
    };
  },
  extend: function extend() {
    var _BaseDirective$_getMe = BaseDirective._getMeta.apply(BaseDirective, arguments),
      _BaseDirective$_getMe2 = _slicedToArray(_BaseDirective$_getMe, 2),
      name = _BaseDirective$_getMe2[0],
      options = _BaseDirective$_getMe2[1];
    return _objectSpread({
      extend: function extend() {
        var _BaseDirective$_getMe3 = BaseDirective._getMeta.apply(BaseDirective, arguments),
          _BaseDirective$_getMe4 = _slicedToArray(_BaseDirective$_getMe3, 2),
          _name = _BaseDirective$_getMe4[0],
          _options = _BaseDirective$_getMe4[1];
        return BaseDirective.extend(_name, _objectSpread(_objectSpread(_objectSpread({}, options), options === null || options === void 0 ? void 0 : options.methods), _options));
      }
    }, BaseDirective._extend(name, options));
  }
};

export { BaseDirective as default };
//# sourceMappingURL=index.mjs.map
