var style=({dt:n})=>`\n.p-image-mask {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-image-preview {\n    position: relative;\n    display: inline-flex;\n    line-height: 0;\n}\n\n.p-image-preview-mask {\n    position: absolute;\n    inset-inline-start: 0;\n    inset-block-start: 0;\n    width: 100%;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    opacity: 0;\n    transition: opacity 0.3s;\n    border: 0 none;\n    padding: 0;\n    cursor: pointer;\n    background: transparent;\n    color: ${n("image.preview.mask.color")};\n    transition: background ${n("image.transition.duration")};\n}\n\n.p-image-preview:hover > .p-image-preview-mask {\n    opacity: 1;\n    cursor: pointer;\n    background: ${n("image.preview.mask.background")};\n}\n\n.p-image-preview-icon {\n    font-size: ${n("image.preview.icon.size")};\n    width: ${n("image.preview.icon.size")};\n    height: ${n("image.preview.icon.size")};\n}\n\n.p-image-toolbar {\n    position: absolute;\n    inset-block-start: ${n("image.toolbar.position.top")};\n    inset-inline-end: ${n("image.toolbar.position.right")};\n    inset-inline-start: ${n("image.toolbar.position.left")};\n    inset-block-end: ${n("image.toolbar.position.bottom")};\n    display: flex;\n    z-index: 1;\n    padding: ${n("image.toolbar.padding")};\n    background: ${n("image.toolbar.background")};\n    backdrop-filter: blur(${n("image.toolbar.blur")});\n    border-color: ${n("image.toolbar.border.color")};\n    border-style: solid;\n    border-width: ${n("image.toolbar.border.width")};\n    border-radius: ${n("image.toolbar.border.radius")};\n    gap: ${n("image.toolbar.gap")};\n}\n\n.p-image-action {\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    color: ${n("image.action.color")};\n    background: transparent;\n    width: ${n("image.action.size")};\n    height: ${n("image.action.size")};\n    margin: 0;\n    padding: 0;\n    border: 0 none;\n    cursor: pointer;\n    user-select: none;\n    border-radius: ${n("image.action.border.radius")};\n    outline-color: transparent;\n    transition: background ${n("image.transition.duration")}, color ${n("image.transition.duration")}, outline-color ${n("image.transition.duration")}, box-shadow ${n("image.transition.duration")};\n}\n\n.p-image-action:hover {\n    color: ${n("image.action.hover.color")};\n    background: ${n("image.action.hover.background")};\n}\n\n.p-image-action:focus-visible {\n    box-shadow: ${n("image.action.focus.ring.shadow")};\n    outline: ${n("image.action.focus.ring.width")} ${n("image.action.focus.ring.style")} ${n("image.action.focus.ring.color")};\n    outline-offset: ${n("image.action.focus.ring.offset")};\n}\n\n.p-image-action .p-icon {\n    font-size: ${n("image.action.icon.size")};\n    width: ${n("image.action.icon.size")};\n    height: ${n("image.action.icon.size")};\n}\n\n.p-image-action.p-disabled {\n    pointer-events: auto;\n}\n\n.p-image-original {\n    transition: transform 0.15s;\n    max-width: 100vw;\n    max-height: 100vh;\n}\n\n.p-image-original-enter-active {\n    transition: all 150ms cubic-bezier(0, 0, 0.2, 1);\n}\n\n.p-image-original-leave-active {\n    transition: all 150ms cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.p-image-original-enter-from,\n.p-image-original-leave-to {\n    opacity: 0;\n    transform: scale(0.7);\n}\n`;export{style};//# sourceMappingURL=index.mjs.map