import {
  EventBus
} from "./chunk-O5TNY3RC.js";
import {
  inject
} from "./chunk-2QF5QTCF.js";

// node_modules/primevue/confirmationeventbus/index.mjs
var ConfirmationEventBus = EventBus();

// node_modules/primevue/useconfirm/index.mjs
var PrimeVueConfirmSymbol = Symbol();
function useConfirm() {
  var PrimeVueConfirm = inject(PrimeVueConfirmSymbol);
  if (!PrimeVueConfirm) {
    throw new Error("No PrimeVue Confirmation provided!");
  }
  return PrimeVueConfirm;
}

// node_modules/primevue/confirmationservice/index.mjs
var ConfirmationService = {
  install: function install(app) {
    var ConfirmationService2 = {
      require: function require2(options) {
        ConfirmationEventBus.emit("confirm", options);
      },
      close: function close() {
        ConfirmationEventBus.emit("close");
      }
    };
    app.config.globalProperties.$confirm = ConfirmationService2;
    app.provide(PrimeVueConfirmSymbol, ConfirmationService2);
  }
};

export {
  PrimeVueConfirmSymbol,
  useConfirm,
  ConfirmationEventBus,
  ConfirmationService
};
//# sourceMappingURL=chunk-UTIO56YR.js.map
